<?php
require_once('utility.php');
function copy_file_from_vm_to_server_by_vix($argv) {
	/* check number of arguments */
	if(count($argv) != 8) {
		echo "Usage: copy_file_from_vm_to_server_by_vix ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VM_USERNAME VM_PASSWORD VM_PATH SOURCE DESTINATION\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$vm_username = escapeshellarg($argv[3]);
	$vm_password = escapeshellarg($argv[4]);
	$vm_path = escapeshellarg($argv[5]);
	$source = escapeshellarg($argv[6]);
	$destination = escapeshellarg($argv[7]);

	/* execute main function */
	unset($result_array);
	//debug_print("vmrun -T server -h https://$esxi_host/sdk -u $esxi_username -p **** -gu $vm_username -gp **** CopyFileFromGuestToHost $vm_path $source $destination");
    $portNumber = getEsxiPort($esxi_host);
	exec("vmrun -T server -h https://$esxi_host:$portNumber/sdk -u $esxi_username -p $esxi_password -gu $vm_username -gp $vm_password CopyFileFromGuestToHost $vm_path $source $destination 2>&1", $result_array, $return_value);
	/* didn't check return code, anyway, return them */
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

